<?php

use Symfony\Component\Dotenv\Dotenv;

$dotenv = new Dotenv(false);
$dotenv->loadEnv(dirname(__DIR__) . '/.env');

return [

    # cockpit instance name
    'app.name' => $_ENV['APP_NAME'],

    # cockpit session name
    'session.name' => $_ENV['SESSION_NAME'],

    # app custom security key
    # CHANGE THIS IN YOUR CONFIGURATION SETTING
    'sec-key' => $_ENV['SEC_KEY'],

    # site url (optional) - helpful if you're behind a reverse proxy
    'site_url' => $_ENV['SITE_URL'],

    # use mongodb as main data storage
    // 'database' => [
    //     'server' => 'mongodb://localhost:27017',
    //     'options' => [
    //         'db' => $_ENV['DB_NAME']
    //     ],
    //     'auth' => [
    //         'user' => $_ENV['DB_USER'],
    //         'password' => $_ENV['DB_PASS']
    //     ]
    // ],

    # use redis for memory storage
    // 'memory' => [
    //     'server' => 'redis://localhost:55001',
    //     'options' => []
    // ],


    ##
    # Only allow files with the 'png, jpg, jpeg' extension to be uploaded
    ##

    # Only allow 'png, jpg, jpeg' using the Assets API
    'assets' => [
        'allowed_uploads' => 'png, jpg, jpeg, svg, webp'
    ],

    # Only allow 'png, jpg, jpeg' using the Finder API
    'finder.allowed_uploads' => 'png, jpg, jpeg, svg, webp',

    # Define Access-Control (CORS) settings.
    # Those are the default values. You don't need to duplicate them all.
    'cors' => [
        'Access-Control-Allow-Origin' => '*',
        'Access-Control-Allow-Credentials' => 'true',
        'Access-Control-Max-Age' => '1000',
        'Access-Control-Allow-Headers' => 'X-Requested-With, Content-Type, Origin, Cache-Control, Pragma, Authorization, Accept, Accept-Encoding, API-KEY',
        'Access-Control-Allow-Methods' => 'PUT, POST, GET, OPTIONS, DELETE',
        'Access-Control-Expose-Headers' => 'true',
    ],

    # Default administration panel language for new users
    # This requires existing translations as described in the documentation
    'i18n' => 'en',

    # Allowed origins to access the api
    'api.security.origins' => ['*'],

    # The limit for API requests in a given time frame. `0` means no limit (default).
    'api.security.ratelimit' => 0,
    # Time (in seconds) for rate limit window.
    'api.security.ratelimit.time' => 60,

    # store model schema in database instead of filesystem (default)
    // 'content' => [
    //     'models' => ['storage' => 'database']
    // ],

];
