<?php

$app->on('content.item.save', function ($modelName, $data) {

    $model = $this->module('content')->model($modelName);
    $collection = $model['type'] == 'singleton' ? 'content/singletons' : "content/collections/{$modelName}";
    $fields = $model['fields'] ?? [];

    foreach ($fields as $field) {

        // check if slug field and referenced field is in data
        if (isset($field['opts']['slugField'], $data[$field['opts']['slugField']])) {

            $data[$field['name']] = $this->helper('utils')->sluggify($data[$field['opts']['slugField']]);

            $this->dataStorage->save($collection, $data);
            break;
        }
    }
});

